//Lab. 03: To plot the phase portrait of systems having vortex point.

//scilab - 5.5.0
// Operating System : Windows 7, 32-bit

clc;
clear all;
clf;

//System transfer function 
s=poly(0,'s');
g=1/(s^2+4);

// Draw pole zero map of the system
plzr(g);
title('Pole-zero map of the system with critically damped eigen values','fontsize',3)
//Convert the given transfer function into state space form
sys=tf2ss(g);

//Plot of system phase trajectory
sys.c=[1,0;0,1];
sys.d=[0 0]';

t=0:0.2:10;
a1=size(t);
u=zeros(a1(1),a1(2));
figure
for i=-2.0:0.5:2;
    for j=-2:0.5:2;
y1=csim(u,t,sys,[i,j]');
plot(y1(1,:),y1(2,:));
end
end
set(gca(),"grid",[0.3 0.3])
f=get("current_figure") //Current figure handle                
f.background=8
title('Phase portrait of the system with vortex point','fontsize',3)
xlabel('x1(t)','fontsize',2)
ylabel('x2(t)','fontsize',2)

